/*<str>
   <copyright year = 2004-2005>
      <company = 'Gentee, Inc.'  url = 'http://www.gentee.com'  email = info@gentee.com >
      <author = 'Alexey Krivonogov'>
      <file>
This file is part of the Gentee STDLIB library (Linux version).
      </>
   </>
   <desc>
   </>
</>*/

define <export>{
//    str_trim
   TRIM_LEFT    = 0x0001   //  
   TRIM_RIGHT   = 0x0002   //  
   TRIM_ONE     = 0x0004   //      str_trim
   TRIM_PAIR    = 0x0008   //    
//    str_split
   SPLIT_EMPTY  = 0x0001   //   
   SPLIT_NOSYS  = 0x0002   //   <=    
   SPLIT_FIRST  = 0x0004   //    
   SPLIT_QUOTE  = 0x0008   //   "  '
   //   fill
   FILL_LEFT = 0x01   //  
   FILL_LEN  = 0x02   // count -   
   FILL_CUT  = 0x04   //     
}
/*
type str < index = byte >{
   buf   sbuf
}
*/
method str str.init()
{
   this.sbuf += byte( 0 );
   return this
} 

operator uint *( str left )
{
   return left.sbuf.use - 1
}

method uint str.index( uint i )
{
   return this.sbuf.data + i
}

method uint str.ptr
{
   return ?( this, this.sbuf.data, 0 )
}

method str str.copy( uint src )
{
   this.sbuf.copy( src, mlen( src ) + 1 )
   
   return this
} 

//    ,        
method str str.copy( uint src size )
{
   if !size : return this
   
   this.sbuf.copy( src, size )
   if ( src + size - 1 )->byte : this.sbuf += byte( 0 )
   
   return this
} 

operator str =( str left right )
{
   left.sbuf = right.sbuf
   return left
}

operator str +=( str left right )
{
//   left.sbuf.use--   // Doesn't work n += n    
//   left.sbuf += right.sbuf
   left.sbuf.expand( left.sbuf.use + right.sbuf.use )
   mcopy( left.sbuf.data + left.sbuf.use - 1, right.sbuf.data, right.sbuf.use )
   left.sbuf.use += right.sbuf.use - 1   
   
   return left
}

operator str +( str left right result )
{
   result = left
   return result += right
}

method str.print()
{
   printf( this.sbuf.data, *this )
}

func print( str par )
{
   printf( par.sbuf.data, *par )
}

operator uint ==( str left right )
{
   if left.sbuf.use != right.sbuf.use : return 0 
   return !scmp( left.sbuf.data, right.sbuf.data )   
}

operator uint <( str left right )
{
   if scmp( left.sbuf.data, right.sbuf.data ) < 0 : return 1
   return 0
}

operator uint >( str left right )
{
   if scmp(  left.sbuf.data, right.sbuf.data ) > 0 : return 1
   return 0
}

operator uint %==( str left right )
{
   if left.sbuf.use != right.sbuf.use : return 0 
   return !scmpignore( left.sbuf.data, right.sbuf.data )   
}

operator uint %<( str left right )
{
   if scmpignore( left.sbuf.data, right.sbuf.data ) < 0 : return 1
   return 0
}

operator uint %>( str left right )
{
   if scmpignore(  left.sbuf.data, right.sbuf.data ) > 0 : return 1
   return 0
}

method str str.setlen( uint size )
{
   this.sbuf.use = size + 1
   this[ size ] = 0
   return this
}

method str str.reserve( uint size )
{
   this.sbuf.expand( size )
   return this
}

//method str int.str( str result )
method str int.str < result >
{
   result.setlen( 0 )
   int2str( result, "%i", this )
//   return result 
}

//method str uint.str( str result )
method str uint.str < result >
{
   result.setlen( 0 )
   int2str( result, "%u", this )
//   return result 
}

//method str float.str( str result )
method str float.str <result>
{
   result.setlen( 0 )
   float2str( result, "%f", this )
//   return result 
}

//method str long.str( str result )
method str long.str <result>
{
   result.setlen( 0 )
   /*LU
   long2str( result, "%I64i", this )
   LU*/
   long2str( result, "%lli", this )   
//   return result 
}

method str ulong.str<result>
{
   result.setlen( 0 )
   /*LU
   long2str( result, "%I64u", this )
   LU*/
   long2str( result, "%llu", this )   
//   return result 
}

method str double.str<result>
{
   result.setlen( 0 )
   double2str( result, "%e", this ) 
}

operator str +=( str left, int val )
{
   int2str( left, "%i", val )
   return left
}
 
operator str +=( str left, uint val )
{
   int2str( left, "%u", val )
   return left
}

operator str +=( str left, float val )
{
   float2str( left, "%f", val )
   return left
}

operator str +=( str left, long val )
{
   long2str( left, "%I64i", val )
   return left
}
 
operator str +=( str left, ulong val )
{
   long2str( left, "%I64u", val )
   return left
}

operator str +=( str left, double val )
{
   double2str( left, "%g", val )
   return left
}

operator buf +=( buf left, str val )
{
    return left += val.sbuf
}

method int str.int( )
{
   return str2int( this )
}

method uint str.uint( )
{
   return uint( str2int( this ))
}

method float str.float( )
{
   return float( str2double( this ))
}

method long str.long
{
   return str2long( this )
}

method ulong str.ulong
{
   return ulong( str2long( this ))
}

method double str.double
{
   return str2double( this )
}

func str hex2strl( str ret, uint val )
{
   int2str( ret, "%x", val )
   return ret
}

func str hex2stru( str ret, uint val )
{
   int2str( ret, "%X", val )
   return ret
}

func str char2str( str ret, uint val )
{
   int2str( ret, "%c", val )
   return ret
}

method  str str.appendch( uint ch )
{
   this[ *this ] = ch
   this.sbuf += byte( 0 )
      
   return this
}

method  str str.del( uint off len )
{
   uint slen = this.sbuf.use - 1 

   if off > slen : return this
   if off + len > slen : len = slen - off  
   this.sbuf.del( off, len )
   
   this[ this.sbuf.use - 1 ] = 0
      
   return this
}

method uint str.findch( uint symbol, uint right )
{
   return sfindch( this.ptr(), *this, symbol, right )
}

method uint str.findchfrom( uint symbol, uint offset )
{
   return offset + sfindch( this.ptr() + offset, *this - offset, symbol, 0 )
}

method uint str.findchnum( uint symbol, uint i )
{
   uint cur = this.ptr()
   uint end = cur + *this
   
   while i && cur < end
   {
      i--
      cur += sfindch( cur, end - cur, symbol, 0 ) 
      if cur < end && i : cur++
   }
   return cur - this.ptr()
}

method uint str.islast( uint symbol )
{
   if !*this : return 0
   
   if getgentee()->sgentee.multib
   {
      return this.findch( symbol, $TRUE ) == *this - 1
   }

   return this[ *this - 1 ] == symbol
}

method str str.substr( str src, uint off len )
{
   if len && off < *src
   {
      if len > *src - off : len = *src - off
      this.copy( src.ptr() + off, len )
   }
   else : this.setlen( 0 )

   return this
}

method str str.substr( uint off len )
{
   return this.substr( this, off, len )
}

func uint trimsys( uint ptr len )
{
   uint  end = ptr + len->uint
   
   while ptr->byte <= ' ' && ptr < end : ptr++
   while ( end - 1 )->byte <= ' ' && ptr < end : end-- 

   len->uint = end - ptr

   return ptr
}

method str str.trimsys
{
   uint len = *this
   uint ptr
   
   ptr = trimsys( this.ptr(), &len )
   if len != *this : this.substr( this, ptr - this.ptr(), len )
   return this
}

method arr str.lines( arr ret of str, uint trim, arr offset )
{
   uint tlen start end endl len = *this
   
   ret.clear()
   if offset : offset.clear()
   
   while start < len
   {
      end = start
      if offset : offset[ offset.expand(1) - 1 ] = start
      
      while this[ end ] && this[ end ] != 0xA &&
              ( this[ end ] != 0xD || this[ end + 1 ] == 0xA )
      {
         end++
      }
      if this[ end ] : end++
      endl = end
      tlen = end - start
      if trim
      {
         start = trimsys( this.ptr() + start, &tlen ) - this.ptr()
      } 
      ret[ ret.expand( 1 ) - 1 ].substr( this, start, tlen )
      start = endl
   }   
   if this[ start - 1 ] == 0xA || this[ start - 1 ] == 0xD
   {
      ret.expand( 1 )
      if offset : offset[ offset.expand(1) - 1 ] = start
   }
   return ret
}

method arr str.lines( arr ret of str, uint trim )
{
   return this.lines( ret, trim, 0->arr )
}

method str.split( arr result of str, uint symbol, uint flag )
{
   uint  cur = this.ptr()
   uint  end = cur + *this
   uint  found
   uint  i ptr len
   uint  search
   
   //  
   result.clear()
   while ( cur <= end )
   {
      search = symbol
     
      if flag & $SPLIT_QUOTE 
      {
         ptr = cur
         while ptr->byte && ptr->byte <= ' ' : ptr++
         if ptr->byte == '"' || ptr->byte == '''
         {
            search = ptr->byte
            cur = ptr + 1
         }
      }

      if !( flag & $SPLIT_FIRST ) || !*result
      {
         found = sfindch( cur, end - cur, search, 0 )
      }
      else : found = end - cur                        
      
      ptr = cur
      len = found 
      if len && flag & $SPLIT_NOSYS : ptr = trimsys( ptr, &len )

      if len || flag & $SPLIT_EMPTY
      {
         i as result[ result.expand( 1 ) - 1 ]
         i.copy( ptr, len + 1 )
         i.setlen( len )
      }      
      cur += found + 1 
      if search != symbol
      {
         while cur < end && cur->byte <= ' ' : cur++
         if cur->byte == symbol : cur++
      }
   }
}

method str  str.trim( uint symbol, uint flag )
{
   uint rsymbol = symbol
   
   if flag & $TRIM_PAIR
   {
      switch symbol
      {
         case '(' : rsymbol = ')'
         case '{' : rsymbol = '}'
         case '[' : rsymbol = ']'
         case '<' : rsymbol = '>'
      }      
   }
   if  flag & $TRIM_RIGHT 
   {
      while this.islast( rsymbol )
      {
         this.setlen( *this - 1 )
         if flag & $TRIM_ONE : break
      }
   }
   if  flag & $TRIM_LEFT
   {
      uint   cur = this.ptr()
      uint   end = cur + *this

      while cur < end && cur->byte == symbol
      {
         cur++
         if flag & $TRIM_ONE : break
      }
      if cur != this.ptr() : this.del( 0, cur - this.ptr())
   }

   return this;
}
/*LU
method str str.oem2char
{
   OemToCharBuff( this.ptr(), this.ptr(), *this )
   return this
}

method str str.char2oem
{
   CharToOemBuff( this.ptr(), this.ptr(), *this )
   return this
}
LU*/
method str str.clear
{
   return this.setlen( 0 )
}

method str  str.replace( uint offset size, str value )
{
   if offset >= *this : this += value
   else
   {
      value.sbuf.use--
      this.sbuf.replace( offset, size, value.sbuf )   
      value.sbuf.use++
   }
   return this
}

method str  str.insert( uint offset, str value )
{
   return this.replace( offset, 0, value )
}

method str str.fill( str val, uint count flag )
{
   uint  len
   uint  elen
   str   ret
   
   elen = ?( flag & $FILL_LEN, count, *this + count * *val )
   len = ?( elen < *this, 0, elen - *this )
   while *ret < len : ret += val
   ret.setlen( len )
   
   if len
   {
      if flag & $FILL_LEFT : this.insert( 0, ret )
      else : this += ret
   }
   if flag & $FILL_CUT && elen < *this : this.setlen( elen )
   return this
}

method str str.fillspacel( uint len )
{
   return this.fill( " ", len, $FILL_LEFT | $FILL_LEN )
}

method str str.fillspacer( uint len )
{
   return this.fill( " ", len, $FILL_LEN )
}

method str str.repeat( uint count )
{
   str pat = this
   return this.fill( pat, count * *pat, $FILL_CUT | $FILL_LEN )
}

method str str.setlenptr
{
   return this.setlen( mlen( this.ptr()))
}

method uint str.crc
{
   return crc( this.ptr(), *this, 0xFFFFFFFF )
}

method str str.lower
{
	uint i
/*LU   CharLowerBuff( this.ptr(), *this )
LU*/
	fornum i=0, *this
	{
		this[i] = lu_tolower( this[i] )
	}
   return this
}

method str str.lowersub( uint off size )
{
	uint i
   off = min( off, *this - 1 )
   size = min( size, *this - off )
/*LU
   CharLowerBuff( this.ptr() + off, size )
LU*/
   fornum i=off, off + size
	{
		this[i] = lu_tolower( this[i] )
	}
   return this
}
method str str.upper
{
	uint i
/*LU   CharUpperBuff( this.ptr(), *this )
LU*/
	fornum i=0, *this
	{
		this[i] = lu_toupper( this[i] )
	}
   return this
}

method str str.uppersub( uint off size )
{
	uint i
   off = min( off, *this - 1 )
   size = min( size, *this - off )

/*LU   CharUpperBuff( this.ptr() + off, size )
LU*/
	fornum i=off, off + size
	{
		this[i] = lu_toupper( this[i] )
	}
   return this
}

method str str.trimrspace
{
   return this.trim( ' ', $TRIM_RIGHT )
}

method str str.trimspace
{
   return this.trim( ' ', $TRIM_RIGHT | $TRIM_LEFT )
}

method uint str.eqlen( uint ptr )
{
   return !scmplen( this.sbuf.data, ptr, this.sbuf.use - 1 )   
}

method uint str.eqlenign( uint ptr )
{
   return !scmpignlen( this.sbuf.data, ptr, this.sbuf.use - 1 )   
}

method uint str.eqlen( str src )
{
   return this.eqlen( src.ptr())
}

method uint str.eqlenign( str src )
{
   return this.eqlenign( src.ptr())
}

method str str.append( uint src size )
{
   if size 
   {
      this.sbuf.use--
      this.sbuf.append( src, size )
      this.sbuf += byte( 0 )
   }
   return this
}

method str str.quote( uint ch )
{
   str stemp
   
   if this[0] == ch && this.islast( ch ) : return this
   
   char2str( stemp, ch )
   this.insert( 0, stemp )
   return this.appendch( ch )
}

method str str.replacech( str src, uint from, str to )
{
   uint i
   
   this.clear()
   fornum i, *src
   {
      if src[ i ] == from
      {
         this += to
      }
      else : this.appendch( src[i] )      
   }
   return this
}
