/*<search>   
   <copyright year = 2004-2005>
      <company = 'Gentee, Inc.'  url = 'http://www.gentee.com'  email = info@gentee.com >
      <author = 'Alexey Krivonogov'> 
      <file>
This file is part of the Gentee STDLIB library.
      </>
   </>
   <desc>
   </>
</>*/

define <export>{
   QS_IGNCASE  =  0x0001   //  
   QS_WORD     =  0x0002   //  
   QS_BEGINWORD =  0x0004   //  
}

type spattern
{
   uint      pattern     
   uint      size
   reserved  shift[ 1024 ]
   uint      flag       
}

method  spattern spattern.init( buf pattern, uint flag )
{
   qs_init( &this, pattern.ptr(), *pattern, flag )
   return this
}

method  uint spattern.search( buf src, uint offset )
{
   return offset + qs_search( &this, src.ptr() + offset, 
                              *src - offset ) 
}

method uint spattern.search( uint ptr size )
{
   return qs_search( &this, ptr, size ) 
}

method  spattern spattern.init( str pattern, uint flag )
{
   qs_init( &this, pattern.ptr(), *pattern, flag )
   return this
}

method  uint spattern.search( str src, uint offset )
{
   return offset + qs_search( &this, src.ptr() + offset,
                              *src - offset ) 
}

method  uint str.search( str pattern, uint flag )
{
   spattern sp

   sp.init( pattern, flag )
   return sp.search( this, 0 ) < *this 
} 
