/*<file>
   <copyright year = 2004-2005>
      <company = 'Gentee, Inc.'  url = 'http://www.gentee.com'  email = info@gentee.com >
      <author = 'Alexey Krivonogov'>
      <file>
This file is part of the Gentee STDLIB library (Linux version).
      </>
   </>
   <desc>
   </>
</>*/
define <export> {
//    open
   OP_READONLY = 0x0001    //    
   OP_EXCLUSIVE = 0x0002   //    
   OP_CREATE = 0x0004      //  
   OP_ALWAYS = 0x0008      //     
}
/*LU
define {
   GENERIC_RW = 0xC0000000   // $GENERIC_READ | $GENERIC_WRITE
   FILE_SHARE_RW = 0x00000003   // $FILE_SHARE_READ | $FILE_SHARE_WRITE
}LU*/

func uint close( uint handle )
{
/*LU   return CloseHandle( handle )
LU*/
   return !_close( handle )
}


func uint createdir( str name )
{
/*LU   return CreateDirectory( name.ptr(), 0 )
LU*/
	return !_mkdir( name.ptr(), $UMASK )
}

func uint deletedir( str name )
{
/*LU   return RemoveDirectory( name.ptr() )
LU*/
	return !_rmdir( name.ptr() )
}

func uint deletefile( str name )
{
/*LU   return DeleteFile( name.ptr() )
LU*/
	return !_unlink( name.ptr() )
}

func uint getdrivetype( str name )
{
/*LU   if !&name : return GetDriveType( 0 )

   return GetDriveType( name.fappendslash().ptr())
LU*/
	return 0
}

func uint getfileattrib( str name )
{
/*   return GetFileAttributes( name.ptr())
*/
	fstat st
	if !_stat( name.ptr(), &st )
	{
		return st.st_mode
	}
	return -1
}

//-------------------------------------------------

func uint setfileattrib( str name, uint attrib )
{
/*LU   return SetFileAttributes( name.ptr(), attrib )
LU*/
	return !_chmod( name.ptr(), attrib )
}

func uint setattribnormal( str name )
{
/*LU   return setfileattrib( name, $FILE_ATTRIBUTE_NORMAL )
LU*/
	return 0
}

func uint fileexist( str name )
{
   return getfileattrib( name ) != 0xFFFFFFFF
}

func uint direxist( str name )
{
   uint  attr = getfileattrib( name )
   return attr != 0xFFFFFFFF && ( attr & 0xF000 ) == 0x4000
}

func str getmodulename( str dest )
{
/*LU   uint  i

   dest.reserve( 512 )
   i = GetModuleFileName( 0, dest.sbuf.data, 511 )
   dest.setlen( i );
LU*/
   return dest
}

func str getmodulepath( str dest subfolder )
{
   dest.fgetdir( getmodulename( dest ))
   if &subfolder && *subfolder : dest.faddname( subfolder )
   return dest
}
/*LU
func uint getsize( uint handle )
{

  return GetFileSize( handle, 0 )

}
LU*/
func uint getfilesize( str name )
{
	fstat st
	if !_stat( name.ptr(), &st )
	{
		return st.st_size
	}
	return 0
}

func uint movefile( str name newname )
{
/*LU   return MoveFile( name.sbuf.data, newname.sbuf.data )
LU*/
	return !_rename( name.sbuf.data, newname.sbuf.data )
}

func uint open( str name, uint flag )
{
/*LU   uint result = CreateFile( name.ptr(), ?( flag & $OP_READONLY, $GENERIC_READ,
                 $GENERIC_RW ), ?( flag & $OP_EXCLUSIVE, 0,
                 ?( flag & $OP_READONLY, $FILE_SHARE_RW,
                 $FILE_SHARE_RW )), 0, ?( flag & $OP_CREATE,
                 $CREATE_ALWAYS, ?( flag & $OP_ALWAYS, $OPEN_ALWAYS,
                 $OPEN_EXISTING )), 0, 0 )

   return ?( result == $INVALID_HANDLE_VALUE, 0, result )
LU*/
   int fd;
   fd = _open( name.ptr(), ?( flag & $OP_READONLY, $O_RDONLY, $O_RDWR ) |
                    ?( flag & $OP_CREATE, $O_CREAT | $O_TRUNC, 0 ) |
                    ?( flag & $OP_ALWAYS, $O_CREAT, 0 ), $UMASK );
   if fd > 0 && flag & $OP_EXCLUSIVE
   {
      if _flock( fd, $LOCK_EX ) < 0
      {
         _close( fd );
			fd = -1;
      }
   }
	if fd < 0 : fd = 0
	return fd
}

func  uint setpos( uint handle, int offset, uint mode )
{
/*LU   return SetFilePointer( handle, offset, 0, mode )
LU*/
	switch ( mode )
	{
		case $FILE_CURRENT : mode = 1
		case $FILE_END	: mode = 2
		default : mode = 0
	}
	return _lseek( handle, offset, mode )
}

func uint read( uint handle, buf rbuf, uint size )
{
   uint  read

   if size > 16000000
   {
		uint curpos, fsize

		curpos = setpos( handle, 0, $FILE_CURRENT )
		fsize = setpos( handle, 0, $FILE_END )
		setpos( handle, curpos, $FILE_CURRENT )
/*LU      uint fsize = getsize( handle )
LU*/
      if size > fsize : size = fsize
   }
   rbuf.expand( rbuf.use + size + 1 );

/*LU   if ReadFile( handle, rbuf.data + rbuf.use, size, &read, 0 )
LU*/
	read = _read( handle, rbuf.data + rbuf.use, size )
	if read < uint(-$MAXERR)
   {
      rbuf.use += read
   }
	else : read = 0
   return read
}




func uint verifypath( str name, arr dirs of str )
{
   str  fullname drive
   uint i
   arr  names of str

   fullname.ffullname( name )
   fullname.fdelslash()
   if dirs : dirs.delete()

   if direxist( fullname ) : return 1
   
   drive.fgetdrive( fullname )
   fullname.del( 0, *drive )
   fullname.split( names, '/', 0 )

   fornum i = 0,*names
   {
      drive.faddname( names[i] )
      if !direxist( drive )
      {
         if dirs : dirs[ dirs.expand( 1 ) - 1 ] = drive
         if !createdir( drive ) : return 0
      }
   }
   return 1
}

func uint  write( uint handle, buf wbuf )
{
/*LU
   uint  write
   return WriteFile( handle, wbuf.data, *wbuf, &write, 0 ) && write == *wbuf
LU*/
   return _write( handle, wbuf.data, *wbuf ) == *wbuf
}

func str  getcurdir( str dir )
{
   dir.clear()
   dir.reserve( 1024 )
/*LU   GetCurrentDirectory( 512, dir.ptr())
   return dir.setlenptr()LU*/
	if _getcwd( dir.ptr(), 1024 ) != -1
	{
		dir.setlenptr()
	}
	return dir
}

func uint copyfile( str name newname )
{
/*LU   return CopyFile( name.sbuf.data, newname.sbuf.data, 0 )
LU*/
	fstat st
	utime ut
	uint  hdest, hsrc
	uint  size

	if _stat( name.ptr(), &st ) : return 0
	size = st.st_size
 	hsrc = open( name, $OP_READONLY )
   if !hsrc : return 0

	hdest = open( newname, $OP_CREATE )
   if !hdest
   {
      close( hsrc )
   	return 0
   }

   uint copied = 0
	uint icopy
	buf  cbuf
   while size
   {
      icopy = min( size, 0x80000 )
      cbuf.use = 0
      read( hsrc, cbuf, icopy )
      if !write( hdest, cbuf )
      {
        	return 0
      }
      size -= icopy
   }
	close( hdest )
   close( hsrc )

	ut.acttime = st.st_atime
   ut.modtime = st.st_mtime
   
   _chmod( newname.ptr(), st.st_mode )
	_chown( newname.ptr(), st.st_uid, st.st_gid )
   _utime( newname.ptr(), &ut )
   
	return 1
}

func uint  setcurdir( str dir )
{
/*LU   return SetCurrentDirectory( dir.ptr())
LU*/
	return !_chdir( dir.ptr())
}

func str  gettempdir( str dir )
{
   dir.clear()
   return dir = gettemp()
}

//-------------------------------------------------

func arr getdrives( arr drives of str )
{
   buf  stemp
/*LU
   stemp.expand( 512 )
   stemp.use = GetLogicalDriveStrings( 512, stemp.ptr())
   return stemp.getmultistr( drives )
*/
	return drives
}
/*LU
//-------------------------------------------------

func uint getftime( uint handle, filetime ft )
{
   return GetFileTime( handle, 0->filetime, 0->filetime, ft )
}

//-------------------------------------------------

func uint setftime( uint handle, filetime ft )
{
   return SetFileTime( handle, ft, ft, ft )

}LU*/


//-------------------------------------------------

func uint getfiletime( str name, filetime ft )
{
	fstat st
	if !_stat( name.ptr(), &st ) 
	{    
		ft.highdtime = 0
		ft.lowdtime = st.st_mtime
		return 1
	}
	return 0
}

//-------------------------------------------------

func uint setfiletime( str name, filetime ft )
{
	utime ut
   ut.acttime = ft.lowdtime
   ut.modtime = ft.lowdtime 
	return !_utime( name.ptr(), &ut )

}//-------------------------------------------------


func uint isdir( str name )
{
   fstat st
   if _stat( name.ptr(), &st ) : return 0
   return (uint(st.st_mode) & 0xF000 ) == 0x4000
}

func uint islink( str name )
{
   fstat st
   if _lstat( name.ptr(), &st ) : return 0
   return (uint(st.st_mode) & 0xF000 ) == 0xA000
}
