/*<ffind>
   <copyright year = 2004-2005>
      <company = 'Gentee, Inc.'  url = 'http://www.gentee.com'  email = info@gentee.com >
      <author = 'Alexey Krivonogov'>
      <file>
This file is part of the Gentee STDLIB library (Linux version).
      </>
   </>
   <desc>
   </>
</>*/

define <export> {
   //    ffind
   FIND_DIR     = 0x0001    //   
   FIND_FILE    = 0x0002    //   
   FIND_RECURSE = 0x0004    //  
   
   DELF_RO      = 0x0100    //  read-only 
}

type finfo {
   str       fullname
   str       name
   uint      attrib
   filetime  lastwrite
   uint      sizehi
   uint      sizelo
}

type fstack {   
   finfo  info
   str    path   
   uint   find   
   uint   ok   
}

type ffind <index = finfo> {
   stack  deep of fstack
   str    initname
   str    wildcard
   uint   flag
}

method fstack.delete()
{
   if this.find
   {
      /*LU FindClose( this.find ) LU*/
      lu_closedir( this.find )
      this.find = 0
   }
}

method ffind.init( str name, uint flag )
{
   this.deep.clear()
   this.flag = flag
   this.initname = name
   this.wildcard.fnameext( this.initname )
   this.deep.push()
}
/*LU
func  wfd2finfo( WIN32_FIND_DATA  wfd, finfo fi, str path )
{
   fi.name.copy( &wfd.cFileName )
   ( fi.fullname = path ).faddname( fi.name )
   fi.attrib = wfd.dwFileAttributes
   fi.lastwrite = wfd.ftLastWriteTime
   fi.sizehi = wfd.nFileSizeHigh
   fi.sizelo = wfd.nFileSizeLow
}
LU*/

func  st2finfo( fstat st, str name, finfo fi, str path )
{
   fi.name = name
   ( fi.fullname = path ).faddname( fi.name )
   fi.attrib = st.st_mode
   fi.lastwrite.lowdtime = st.st_mtime
   fi.lastwrite.highdtime = 0
   fi.sizehi = 0
   fi.sizelo = st.st_size
}

operator finfo =( finfo left right )
{
   left.fullname = right.fullname
   left.name = right.name
   left.attrib = right.attrib
   left.lastwrite = right.lastwrite
   left.sizehi = right.sizehi
   left.sizelo = right.sizelo

   return left
}

method finfo ffind.getinfo
{
   return this.deep.top()->finfo   
}


method finfo ffind.found( /*WIN32_FIND_DATA wfd*/ uint wfd )
{
   uint  flag = this.flag
   uint  current = this.deep.top()
   fstat st
	uint  isdir, islink
/*LU   if !wfd.cFileName[0] : goto next
   
   label again
   current as fstack

   current.ok = 0
   if wfd.cFileName[0] == '.' && ( !wfd.cFileName[1] ||
           ( wfd.cFileName[1] == '.' && !wfd.cFileName[2] ))
   {
      goto next
   }  
   if wfd.dwFileAttributes & $FILE_ATTRIBUTE_DIRECTORY 
     {
       if flag & $FIND_DIR : current.ok = 1
   }
   else : if flag & $FIND_FILE : current.ok = 1
   
   if current.ok
   {
      current.ok = sfwildcard( &wfd.cFileName, this.wildcard.ptr()) 
   }

   if wfd.dwFileAttributes & $FILE_ATTRIBUTE_DIRECTORY &&
      flag & $FIND_RECURSE
   {
      str   newfld
      uint  find
      
      wfd2finfo( wfd, current.info, current.path )

      newfld = current.info.fullname
      current as this.deep.push()
      current as fstack
      current.path = newfld
      newfld.faddname( "*" )
      
      current.find = FindFirstFile( newfld.ptr(), wfd )
      if current.find != $INVALID_HANDLE_VALUE 
      {
         goto again
      }
      current as this.deep.pop()
      current as fstack
   }
   if current.ok 
   {
      wfd2finfo( wfd, current.info, current.path ) 
      return this.getinfo()
   }

   label next
   if FindNextFile( current.find, wfd ) : goto again

   FindClose( current.find )
   current.find = 0
LU*/
   str fullname
   str fname     
   
   if !wfd: goto next   
   
   label again   
   current as fstack 
   current.ok = 0
   if wfd->dirent.d_name[0] == '.' && ( !wfd->dirent.d_name[1] ||
      ( wfd->dirent.d_name[1] == '.' && !wfd->dirent.d_name[2] ))
   {      
      goto next
   }   
   fullname = current.path 
   fname.copy( &wfd->dirent.d_name )      
   fullname.faddname( "".copy( &wfd->dirent.d_name ) )
   if _lstat( fullname.ptr(), &st ) : goto next
   islink = (uint(st.st_mode) & 0xF000 ) == 0xA000   
   if _stat( fullname.ptr(), &st ) : goto next
   isdir = (uint( st.st_mode ) & 0xF000 ) == 0x4000
   if isdir 
   {
      if flag & $FIND_DIR : current.ok = 1
   }
   else : if flag & $FIND_FILE : current.ok = 1
   if current.ok
   {      
      current.ok = sfwildcard( fname.ptr(), this.wildcard.ptr())       
   }
   //st2finfo( st, &wfd->dirent.d_name, current.info, current.path )
   if isdir && !islink && ( flag & $FIND_RECURSE )
   {
      str   newfld
      uint  find      
      //wfd2finfo( wfd, current.info, current.path )
      st2finfo( st, fname, current.info, current.path )
      newfld = current.info.fullname
      current as this.deep.push()
      current as this.deep.pop()
      
      current as this.deep.push()
      current as fstack
      current.path = newfld
      //newfld.faddname( "*" )
      
      current.find = lu_opendir( newfld.ptr() )
      //current.find = FindFirstFile( newfld.ptr(), wfd )
      if current.find
      {  
         uint twfd         
         twfd = lu_readdir( current.find )
         if twfd && twfd != -1 && twfd->dirent.d_ino
         {         
            wfd = twfd
            goto again
         }         
         lu_closedir( current.find )
         current.find = 0
      }
      current as this.deep.pop()
      current as fstack         
   }
         
   if current.ok 
   {
      //wfd2finfo( wfd, current.info, current.path ) 
      st2finfo( st, fname, current.info, current.path ) 
      return this.getinfo()
   }
         
   label next
   //if FindNextFile( current.find, wfd ) : goto again
   wfd = lu_readdir( current.find )         
   if wfd /*&& wfd->dirent.d_ino*/: goto again
   //FindClose( current.find )
   lu_closedir( current.find )
   current.find = 0
   if *this.deep > 1 
   {
      current as this.deep.pop()
      current as fstack      
      if ( current.ok ) : this.getinfo()
      else : goto next
   }  
      
   return this.getinfo()
}

method uint ffind.next
{
  /*LU WIN32_FIND_DATA  wfd*/
   return &this.found( /*LU wfd LU*/ 0 )

}

method uint ffind.first
{
   /*LU WIN32_FIND_DATA  wfd
   str              temp
   uint             start

   start = this.deep.top()
   start as fstack

   if !*this.initname
   {
      start.find = 0
      return &start.info
   }
   ( temp = this.initname ).fdelslash()

   if this.flag & $FIND_RECURSE
   {
      temp.fgetdir( temp )
      temp.faddname( "*" )
   }
   start.find = FindFirstFile( temp.ptr(), wfd )
   if start.find == $INVALID_HANDLE_VALUE
   {
      start.find = 0
      return &start.info
   }
   start.path.fgetdir( temp )
   return &this.found( wfd )
	LU*/
   uint             wfd
   str              temp
   uint             start

   start = this.deep.top()
   start as fstack

   if !*this.initname
   {
      start.find = 0
      return &start.info
   }
   ( temp = this.initname ).fdelslash()
   temp.fgetdir( temp )
   temp.fappendslash()
   start.find = lu_opendir( temp.ptr() )
   //start.find = FindFirstFile( temp.ptr(), wfd )
   if !start.find 
   {
      //start.find = 0
      return &start.info
   }         
   wfd = lu_readdir( start.find )         
   //start.path.fgetdir( temp )         
   start.path = temp
   return &this.found( wfd )   
}

method  uint  ffind.eof( )
{
   return !this.deep.top()->fstack.find
}

func uint getfileinfo( str name, finfo fi )
{
/*LU   ffind fd
   fd.init( name, $FIND_DIR | $FIND_FILE )
   foreach finfo cur, fd
   {
      str dir, n
      fi = cur
      name.fsplit( dir, n )
      if n == "gentee"
      {
         print( cur.fullname + "\n" )
      }
      else: return 1
   }LU*/
   
   str dir, n
   fstat st
   
   name.fsplit( dir, n )
   if _stat( name.ptr(), &st ) : return 0
      
   st2finfo( st, n, fi, dir )
   
   return 1
}

func  delfiles( str name, uint flag )
{
   ffind fd

   fd.init( name, flag )

   foreach finfo cur, fd
   {
      if /*LU cur.attrib & $FILE_ATTRIBUTE_DIRECTORY LU*/( cur.attrib & 0xF000 ) == 0x4000
      {
         delfiles( cur.fullname + "/*.*" , flag | $FIND_FILE )
         deletedir( cur.fullname )
      }
      else
      {
         /*LU if flag & $DELF_RO && cur.attrib & $FILE_ATTRIBUTE_READONLY
         {
            setattribnormal( cur.fullname )
         } LU*/
         deletefile( cur.fullname )
      }
   }
}

