/*<datetime>
   <copyright year = 2004-2005>
      <company = 'Gentee, Inc.'  url = 'http://www.gentee.com'  email = info@gentee.com >
      <author = 'Alexey Krivonogov'>
      <file>
This file is part of the Gentee STDLIB library (Linux version).
      </>
   </>
   <desc>
   </>
</>*/

/*LU define
{
   LANG_NEUTRAL   = 0x00
   LANG_ENGLISH   = 0x09
   LANG_FRENCH    = 0x0c
   LANG_GERMAN    = 0x07

   SUBLANG_NEUTRAL = 0x00
   SUBLANG_DEFAULT = 0x01
   SUBLANG_SYS_DEFAULT = 0x02
   SUBLANG_ENGLISH_US  = 0x01
   SUBLANG_FRENCH      = 0x01
   SUBLANG_GERMAN      = 0x01
   SORT_DEFAULT        = 0x0

   LOCALE_SMONTHNAME1 = 0x00000038
   LOCALE_SABBREVDAYNAME1 = 0x00000031   // abbreviated name for Monday
   LOCALE_IFIRSTDAYOFWEEK = 0x0000100C   // first day of week
}
LU*/
/*LU ADD*/
define {
  ABDAY_1 = 0x20000 /* Sun */
    
  DAY_1   = 0x20007 /* Sunday 07*/
  
  ABMON_1 = 0x2000E /* Jan 0E*/
  
  MON_1   = 0x2001A /* January 1A*/
  
  _NL_TIME_FIRST_WEEKDAY = 0x20068//68
}

extern{ 
method uint datetime.dayofyear
method datetime datetime.gettime
 }
func timetolinux( datetime systime, tm linuxtime )
{
   linuxtime.tm_sec   = systime.second
   linuxtime.tm_min   = systime.minute
   linuxtime.tm_hour  = systime.hour
   linuxtime.tm_mday  = systime.day
   linuxtime.tm_mon   = systime.month - 1
   linuxtime.tm_year  = systime.year - 1900
   linuxtime.tm_wday  = systime.dayofweek 
   linuxtime.tm_yday  = systime.dayofyear()
   linuxtime.tm_isdst = 0 
}

/*LU ADD*/
func timefromlinux( datetime systime, tm linuxtime )
{
   systime.second    = linuxtime.tm_sec  
   systime.minute    = linuxtime.tm_min  
   systime.hour      = linuxtime.tm_hour 
   systime.day       = linuxtime.tm_mday 
   systime.month     = linuxtime.tm_mon + 1 
   systime.year      = linuxtime.tm_year + 1900
   systime.dayofweek = linuxtime.tm_wday                        
   systime.msec      = 0  
}

func  getdatetime( datetime systime, str date, str time )
{  
   tm linuxtime;
   timetolinux( systime, linuxtime );
   if date
   {      
      date.reserve( 64 )
      date.setlen( lu_strftime( date.sbuf.data, date.sbuf.size, "%x".ptr(), &linuxtime ))
/*LU      date.setlen( GetDateFormat( 0, 0, systime, 0, date.sbuf.data,
                                  date.sbuf.size ) - 1 )LU*/
   }
   if time
   {
      time.reserve( 64 )
      time.setlen( lu_strftime( time.sbuf.data, time.sbuf.size, "%X".ptr(), &linuxtime ))
/*LU      time.setlen( GetTimeFormat( 0, 0, systime, 0, time.sbuf.data,
                                  time.sbuf.size ) - 1 )LU*/
   }

}

func str getdateformat( datetime systime, str format date )
{
   date.reserve( 64 )
/*LU   return date.setlen( GetDateFormat( 0, 0, systime, format.ptr(),
                                     date.ptr(), 64 ) - 1 )
LU*/
   tm linuxtime;
   timetolinux( systime, linuxtime );
   return date.setlen( lu_strftime( date.sbuf.data, date.sbuf.size, "%x".ptr(), &linuxtime ))	
}

func str gettimeformat( datetime systime, str format time )
{
   time.reserve( 64 )
/*LU   return time.setlen( GetTimeFormat( 0, 0, systime, format.ptr(),
                                     time.ptr(), 64 ) - 1 )
LU*/
   tm linuxtime;
   timetolinux( systime, linuxtime );   
	return time.setlen( lu_strftime( time.sbuf.data, time.sbuf.size, "%X".ptr(), &linuxtime ))
}

operator datetime =( datetime left right )
{
    left.year = right.year
    left.month = right.month
    left.day = right.day
    left.hour = right.hour
    left.minute = right.minute
    left.second = right.second
    left.msec = right.msec
    return left
}

operator uint ==( datetime left right )
{
    if left.year != right.year : return 0
    if left.month != right.month : return 0
    if left.day != right.day : return 0
    if left.hour != right.hour : return 0
    if left.minute != right.minute : return 0
    if left.second != right.second : return 0
    if left.msec != right.msec : return 0
    return 1
}

operator uint <( datetime left right )
{
    if left.year < right.year : return 1
    if left.year > right.year : return 0
    if left.month < right.month : return 1
    if left.month > right.month : return 0
    if left.day < right.day : return 1
    if left.day > right.day : return 0
    if left.hour < right.hour : return 1
    if left.hour > right.hour : return 0
    if left.minute < right.minute : return 1
    if left.minute > right.minute : return 0
    if left.second < right.second : return 1
    if left.second > right.second : return 0
    if left.msec < right.msec : return 1
//    if left.msec > right.msec : return 0
    return 0
}

operator uint >( datetime left right )
{
    if left.year > right.year : return 1
    if left.year < right.year : return 0
    if left.month > right.month : return 1
    if left.month < right.month : return 0
    if left.day > right.day : return 1
    if left.day < right.day : return 0
    if left.hour > right.hour : return 1
    if left.hour < right.hour : return 0
    if left.minute > right.minute : return 1
    if left.minute < right.minute : return 0
    if left.second > right.second : return 1
    if left.second < right.second : return 0
    if left.msec > right.msec : return 1
//    if left.msec > right.msec : return 0
    return 0
}

func uint  isleapyear( ushort year )
{
   return ?( !( year % 4 ) && ( ( year % 100 ) || !( year % 400 )), 1, 0 )
}

func uint  daysinmonth( ushort year month )
{
   buf   months

   if !month : month = 1
   if month > 12 : month = 12

   months = '\i 31, \( byte( ?( isleapyear( year ), 29, 28))), 31, 30, 31,
             30, 31, 31, 30, 31, 30, 31'
   return uint( months[ month - 1 ] )
}

method uint datetime.dayofyear
{
   uint  i  result

   fornum i = 1, this.month
   {
      result += daysinmonth( this.year, i )
   }
   return result + this.day
}

func int days( datetime left right )
{
   uint  less great
   int   result
   uint  i

   less as left
   great as right

   if left > right
   {
      less as right
      great as left
   }

   for  i = less.year, i < great.year, i++
   {
      result += ?( isleapyear( i ), 366, 365 )
   }
   result -= less.dayofyear()
   result += great.dayofyear()

   return ?( left > right, -result, result )
}

method datetime datetime.gettime()
{
/*LU   GetLocalTime( this )
LU*/
	filetime ftime
	timezone ztime
   tm linuxtime

	_gettimeofday( &ftime, &ztime )   
   lu_localtime_r( &ftime.lowdtime, &linuxtime )
   timefromlinux( this, linuxtime )
   this.msec = ftime.highdtime / 1000   	
   return this
}

method uint datetime.dayofweek
{
   datetime curtime
   int  dif
/*LU
   GetLocalTime( curtime )
LU*/
   curtime.gettime()
   
   dif = days( this, curtime )
   this.dayofweek = ( 7 + curtime.dayofweek - ( dif % 7 )) % 7
   return uint( this.dayofweek )

}

operator datetime +=( datetime left, uint next )
{
   uint dif i
   uint curday = left.dayofyear()

   while ( dif = ?( isleapyear( left.year ), 366, 365 ) - curday ) < next
   {
      left.year++
      next -= dif + 1
      left.month = 1
      left.day = 1
      curday = 1
   }
   while ( dif = daysinmonth( left.year, left.month ) - left.day ) < next
   {
      left.month++
      next -= dif + 1
      left.day = 1
   }
   left.day += next

   return left
}

operator datetime -=( datetime left, uint next )
{
   uint dif i
   uint curday = left.dayofyear()

   while curday <= next
   {
      left.year--
      next -= curday
      left.month = 12
      left.day = 31
      curday = ?( isleapyear( left.year ), 366, 365 )
   }
   while left.day <= next
   {
      left.month--
      next -= left.day
      left.day = daysinmonth( left.year, left.month )
   }
   left.day -= next

   return left
}

method  datetime  datetime.setdate( uint day month year )
{
   if !year : year = 1
   if year > 0xFFFF : year = 0xFFFF
   this.year = year
   if !month : month = 1
   if month > 12 : month = 12
   this.month = month
   if !day : day = 1
   if day > daysinmonth( year, month ) : day = daysinmonth( year, month )
   this.day = day
   this.dayofweek()

   return this
}

func uint  makelangid( uint primary sublang )
{
   return ( sublang << 10 ) | primary
}

func uint  makelcid( uint langid sortid )
{
  return ( sortid << 16 ) | langid
}
/*
func uint localeenus()
{
   uint langid = makelangid( $LANG_ENGLISH, $SUBLANG_ENGLISH_US )
   return makelcid( langid, $SORT_DEFAULT)
}
*/
/*LU func uint localeuser()
{
   uint langid = makelangid( $LANG_NEUTRAL, $SUBLANG_DEFAULT )
//   uint langid = makelangid( $LANG_FRENCH, 0x3 )

   return makelcid( langid, $SORT_DEFAULT)
   
   return 0;
}

func uint localesystem()
{
   uint langid = makelangid( $LANG_NEUTRAL, $SUBLANG_SYS_DEFAULT )
   return makelcid( langid, $SORT_DEFAULT )

   return 0;   
}
LU*/

func  str nameofmonth( str ret, uint month )
{
   if month > 12 : month = 12
   if !month : month = 1
/*LU   ret.reserve( 32 )
   GetLocaleInfo( localeuser(),
                  $LOCALE_SMONTHNAME1 + month - 1,
                  ret.ptr(), 32 )

   ret.setlenptr()
LU*/
   ret.copy( lu_nl_langinfo( $ABMON_1 + month - 1 ))
   return ret
}

func  uint  firstdayofweek
{      
/*LU
   str  ret
   ret.reserve( 8 )
   GetLocaleInfo( localeuser(),
                  $LOCALE_IFIRSTDAYOFWEEK,
                  ret.ptr(), 8 )
   ret.setlenptr()
   return ( uint( ret ) + 1 ) % 7
LU*/      
   return lu_nl_langinfo( $_NL_TIME_FIRST_WEEKDAY )->byte % 7  
}

func  str abbrnameofday( str ret, uint dayofweek )
{   
/*LU
   ret.reserve( 24 )
   dayofweek %= 7
   if !dayofweek : dayofweek = 7

   GetLocaleInfo( localeuser(),
                  $LOCALE_SABBREVDAYNAME1 + dayofweek - 1,
                  ret.ptr(), 24 )
   ret.setlenptr()
LU*/
   ret.copy( lu_nl_langinfo( $ABDAY_1 + dayofweek%7 ))    
   return ret
}

operator filetime =( filetime left right )
{
   left.lowdtime = right.lowdtime
   left.highdtime = right.highdtime

   return left
}

operator uint ==( filetime left right )
{
/*LU
   return !CompareFileTime( left, right )
LU*/
	return left.lowdtime == right.lowdtime
}

operator uint <( filetime left right )
{
/*LU   return CompareFileTime( left, right ) < 0
LU*/
	return left.lowdtime < right.lowdtime
}

operator uint >( filetime left right )
{
/*LU   return CompareFileTime( left, right ) > 0
LU*/
	return left.lowdtime > right.lowdtime
}

//-------------------------------------------------

func datetime ftimetodatetime( filetime ft, datetime dt, uint local )
{
/*LU filetime ftime = ft

   if local : FileTimeToLocalFileTime( ft, ftime )
   FileTimeToSystemTime( ftime, dt )
   return dt
LU*/
   tm linuxtime

   if local : lu_localtime_r( &ft.lowdtime, &linuxtime )
   else : lu_gmtime_r( &ft.lowdtime, &linuxtime )
   timefromlinux( dt, linuxtime )
   dt.msec = ft.highdtime
      
	return dt
}

//-------------------------------------------------

func  getfiledatetime( filetime ftime, str date, str time )
{
   datetime st

   ftimetodatetime( ftime, st, 1 )
   getdatetime( st, date, time )
}

//-------------------------------------------------

func uint datetimetoftime( datetime dt, filetime ft )
{
/*LU
   return SystemTimeToFileTime( dt, ft )
LU*/
   tm linuxtime
   timetolinux( dt, linuxtime ) 
   ft.lowdtime = lu_mktime( &linuxtime )   
   ft.highdtime = 0
	return ft.lowdtime != -1
}

//-------------------------------------------------

operator datetime -( datetime left right result )
{
   uint  dt  shift, xshift

   dt as left
   result = right

   if left > right
   {
      result = left
      dt as right
   }
   result.year = 0
   result.month = 0
   result.day = abs( days( left, right ))
   if result.msec < dt.msec
   {
      shift = 1
      result.msec += 1000
   }
   result.msec -= dt.msec
   if result.second < dt.second + shift
   {
      xshift = 1
      result.second += 60
   }
   result.second -= dt.second + shift
   shift = 0

   if result.minute < dt.minute + xshift
   {
      shift = 1
      result.minute += 60
   }
   result.minute -= dt.minute + xshift
   xshift = 0
   if result.hour < dt.hour + shift
   {
      xshift = 1
      result.hour += 24
   }
   result.hour -= dt.hour + shift
   result.day -= xshift

   return result
}

//-------------------------------------------------

operator datetime -=( datetime left right )
{
   return left = left - right
}
