/*<bsfile>
   <copyright year = 2004-2005>
      <company = 'Gentee, Inc.'  url = 'http://www.gentee.com'  email = info@gentee.com >
      <author = 'Alexey Krivonogov'>
      <file>
This file is part of the Gentee STDLIB library (Linux version).
      </>
   </>
   <desc>
   </>
</>*/

method buf buf.read( str filename )
{
   uint file
   
   this.use = 0
   
   if file = open( filename, $OP_READONLY )
   {
      /*LU
      read( file, this, getsize( file ))
      LU*/
      read( file, this, getfilesize( filename ))      
      close( file )
   }
   return this
}

method uint buf.write( str filename )
{
   uint file wr
   
   if file = open( filename, $OP_CREATE )
   {
      wr = write( file, this )
      close( file )
      return wr
   }
   return 0
}

method uint buf.writeappend( str filename )
{
   uint file wr
   
   if file = open( filename, $OP_ALWAYS )
   {
      setpos( file, 0, $FILE_END )
      wr = write( file, this )
      close( file )
      return wr
   }
   return 0
}

method uint buf.write( uint handle, uint pos, uint off, uint size )
{
   uint write

   if setpos( handle, pos, $FILE_BEGIN ) != pos : return 0
   
/*LU
   return WriteFile( handle, this.data + off, size, &write, 0 ) &&
                     write == size
LU*/
   return _write( handle, this.data + off, size ) == size
}

method uint buf.write( uint handle )
{
/*LU
   uint write
   
   return WriteFile( handle, this.data, this.use, &write, 0 ) &&
                     write == this.use
LU*/
   return _write( handle, this.data, this.use ) == this.use
}

method str str.read( str filename )
{
   this.sbuf.read( filename )
   this.setlen( *this + 1 )
   return this
}

method uint str.write( str filename )
{
   uint wr

   this.sbuf.use--
   wr = this.sbuf.write( filename )
   this.sbuf.use++
   return wr
}

method uint str.write( uint handle )
{
/*LU   
   uint write

   return WriteFile( handle, this.ptr(), *this, &write, 0 ) &&
                     write == *this
LU*/
   return _write( handle, this.ptr(), *this ) == *this

}
