package demo.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

/**
 * 
 * @author MAbernethy
 */
public class FlightTableRenderer extends DefaultTableCellRenderer
{	
	public Component getTableCellRendererComponent(JTable table,
												   Object value,
												   boolean isSelected,
												   boolean hasFocus,
												   int row,
												   int column)
	{
		setText(value.toString());
		if (column == 2 || column == 3)
			setHorizontalAlignment(SwingConstants.RIGHT);
		else
			setHorizontalAlignment(SwingConstants.LEFT);
		
		if (((Integer)table.getValueAt(row, 3)).intValue() < 1)
		{
			setBackground(Color.GRAY);
			setForeground(Color.WHITE);
		}
		else
		{
			if (isSelected)
			{
				setBackground(Color.GREEN);
				setForeground(Color.BLACK);
			}	
			else
			{
				setBackground(Color.WHITE);
				setForeground(Color.BLACK);
			}
		}
		return this;		   
												   
	}
}
