package demo.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

import javax.swing.ComboBoxModel;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.table.AbstractTableModel;

import com.sun.java.swing.SwingUtilities2;
import com.sun.java.swing.plaf.motif.MotifLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;

/**
 * 
 * @author MAbernethy
 */
public class FlightReservation extends JFrame implements ActionListener, ListSelectionListener
{

	private javax.swing.JPanel jContentPane = null;

	private javax.swing.JLabel lblDepart = null;
	private javax.swing.JLabel lblDest = null;
	private javax.swing.JButton btnSearch = null;
	private javax.swing.JTable tblFlights = null;
	private javax.swing.JScrollPane jScrollPane = null;
	private javax.swing.JFormattedTextField txtNumTixx = null;
	private javax.swing.JLabel lblNumTixx = null;
	private JCoolButton btnPurchase = null;
	private javax.swing.JComboBox comboDepart = null;
	private javax.swing.JComboBox comboDest = null;
	
	private FlightTableModel flightModel;
	private CityComboModel comboModel1;
	private CityComboModel comboModel2;
	
	public FlightReservation()
	{
		super();
		initialize();
		
		getTxtNumTixx().setEnabled(false);
		getLblNumTixx().setEnabled(false);
		getBtnPurchase().setEnabled(false);
		
		flightModel = new FlightTableModel();
		TableSorter sorter = new TableSorter(flightModel, getTblFlights().getTableHeader());
		getTblFlights().setModel(sorter);
		
		comboModel1 = new CityComboModel(DataHandler.getCities());
		comboModel2 = new CityComboModel(DataHandler.getCities());
		
		getComboDepart().setModel(comboModel1);
		getComboDest().setModel(comboModel2);
		
		getTblFlights().setDefaultRenderer(Object.class, new FlightTableRenderer());
		
	}

	private void initialize()
	{
		this.setSize(560, 330);
		this.setContentPane(getJContentPane());
		this.setTitle("Flight Reservation");
	}
	
	public void actionPerformed(ActionEvent e)
	{
		if (e.getSource() == getBtnSearch())
		{
			final String dest = getComboDest().getSelectedItem().toString();
			final String depart = getComboDepart().getSelectedItem().toString();
			SwingWorker worker = new SwingWorker()
			{
				public Object construct()
				{
					List l = DataHandler.searchRecords(depart, dest);
					return l;
				}
				
				public void finished()
				{
					flightModel.updateData((List)get());
				}
			};
			worker.start();
		}
		else if (e.getSource() == getBtnPurchase())
		{
			final Object o = flightModel.getData().get(getTblFlights().getSelectedRow());
			final int tixx = Integer.parseInt(getTxtNumTixx().getText());
			getTxtNumTixx().setText("");
			SwingWorker worker = new SwingWorker()
			{
				public Object construct()
				{
					try
					{
						DataHandler.updateRecords(o, tixx);
					}
					catch (Exception ex)
					{
						JOptionPane.showConfirmDialog(null, ex.getMessage(), "Error", JOptionPane.OK_CANCEL_OPTION, JOptionPane.ERROR_MESSAGE);
					}	
					return null;
				}
			};
			worker.start();
		}
	}
	
	public void valueChanged(ListSelectionEvent e)
	{
		boolean selected = getTblFlights().getSelectedRow() > -1;
		getLblNumTixx().setEnabled(selected);
		getTxtNumTixx().setEnabled(selected);
		getBtnPurchase().setEnabled(selected);
	}
	
	private class FlightTableModel extends AbstractTableModel
	{
		private List data = new ArrayList();
		
		public void updateData(List l)
		{
			data = l;
			fireTableDataChanged();
		}	
		
		public List getData()
		{
			return data;	
		}
		
		public int getRowCount()
		{
			return data.size();
		}

		public int getColumnCount()
		{
			return 4;
		}
		
		public String getColumnName(int col)
		{
			if (col == 0)
				return "Departure";
			else if (col == 1)
				return "Destination";
				else if (col == 2)
					return "Flight Num";
			else
				return "Number of Tixx";
		}
		
		public boolean isCellEditable(int row, int col)
		{
			return col == 3;
		}
		
		public void setValueAt(Object value, int row, int col)
		{
			if (col == 3)
				((Flight)data.get(row)).setRemainingTixx(new Integer(value.toString()).intValue());
		}

		public Object getValueAt(int row, int col)
		{
			if (col == 0)
				return ((Flight)(data.get(row))).getDeparture();
			else if (col == 1)
				return ((Flight)(data.get(row))).getDestination();
			else if (col == 2)
				return new Integer(((Flight)(data.get(row))).getFlightNum());
			else
				return new Integer(((Flight)(data.get(row))).getRemainingTixx());
		}
		
	}
	
	private class CityComboModel implements ComboBoxModel
	{
		private List data = new ArrayList();
		private int selected = 0;

		public CityComboModel(List list)
		{
			data = list;
		}

		public void setSelectedItem(Object o)
		{
			selected = data.indexOf(o);
		}

		public Object getSelectedItem()
		{
			return data.get(selected);
		}

		public int getSize()
		{
			return data.size();
		}

		public Object getElementAt(int i)
		{
			return data.get(i);
		}

		public void addListDataListener(ListDataListener arg0)
		{
		}

		public void removeListDataListener(ListDataListener arg0)
		{
		}
	}

	public static void main(String[] args)
	{
		SwingUtilities.invokeLater(new Runnable()
		{
			public void run()
			{
				try
				{
				UIManager.setLookAndFeel(new FlightLookAndFeel());
				}
				catch (Exception ex) {}
				FlightReservation f = new FlightReservation();
				f.setVisible(true);
			}
		}
		);
	}



	private javax.swing.JPanel getJContentPane()
	{
		if (jContentPane == null)
		{
			jContentPane = new javax.swing.JPanel();
			java.awt.GridBagConstraints consGridBagConstraints2 = new java.awt.GridBagConstraints();
			java.awt.GridBagConstraints consGridBagConstraints3 = new java.awt.GridBagConstraints();
			java.awt.GridBagConstraints consGridBagConstraints1 = new java.awt.GridBagConstraints();
			java.awt.GridBagConstraints consGridBagConstraints4 = new java.awt.GridBagConstraints();
			java.awt.GridBagConstraints consGridBagConstraints6 = new java.awt.GridBagConstraints();
			java.awt.GridBagConstraints consGridBagConstraints7 = new java.awt.GridBagConstraints();
			java.awt.GridBagConstraints consGridBagConstraints5 = new java.awt.GridBagConstraints();
			java.awt.GridBagConstraints consGridBagConstraints8 = new java.awt.GridBagConstraints();
			java.awt.GridBagConstraints consGridBagConstraints9 = new java.awt.GridBagConstraints();
			consGridBagConstraints8.insets = new java.awt.Insets(32,6,8,18);
			consGridBagConstraints8.ipadx = 68;
			consGridBagConstraints8.fill = java.awt.GridBagConstraints.HORIZONTAL;
			consGridBagConstraints8.weightx = 1.0;
			consGridBagConstraints8.gridwidth = 2;
			consGridBagConstraints8.gridy = 0;
			consGridBagConstraints8.gridx = 1;
			consGridBagConstraints2.insets = new java.awt.Insets(33,3,10,5);
			consGridBagConstraints2.ipady = 6;
			consGridBagConstraints2.ipadx = 27;
			consGridBagConstraints2.gridy = 0;
			consGridBagConstraints2.gridx = 3;
			consGridBagConstraints6.insets = new java.awt.Insets(11,17,15,4);
			consGridBagConstraints6.ipady = 5;
			consGridBagConstraints6.ipadx = 36;
			consGridBagConstraints6.gridwidth = 2;
			consGridBagConstraints6.gridy = 2;
			consGridBagConstraints6.gridx = 0;
			consGridBagConstraints4.insets = new java.awt.Insets(7,15,4,18);
			consGridBagConstraints4.ipady = -246;
			consGridBagConstraints4.ipadx = 66;
			consGridBagConstraints4.fill = java.awt.GridBagConstraints.BOTH;
			consGridBagConstraints4.weighty = 1.0;
			consGridBagConstraints4.weightx = 1.0;
			consGridBagConstraints4.gridwidth = 6;
			consGridBagConstraints4.gridy = 1;
			consGridBagConstraints4.gridx = 0;
			consGridBagConstraints7.insets = new java.awt.Insets(5,96,10,18);
			consGridBagConstraints7.ipady = 6;
			consGridBagConstraints7.ipadx = 10;
			consGridBagConstraints7.gridwidth = 2;
			consGridBagConstraints7.gridy = 2;
			consGridBagConstraints7.gridx = 4;
			consGridBagConstraints3.insets = new java.awt.Insets(30,8,6,18);
			consGridBagConstraints3.ipady = 3;
			consGridBagConstraints3.gridy = 0;
			consGridBagConstraints3.gridx = 5;
			consGridBagConstraints1.insets = new java.awt.Insets(33,14,10,6);
			consGridBagConstraints1.ipady = 6;
			consGridBagConstraints1.ipadx = 34;
			consGridBagConstraints1.gridy = 0;
			consGridBagConstraints1.gridx = 0;
			consGridBagConstraints5.insets = new java.awt.Insets(11,5,16,2);
			consGridBagConstraints5.ipadx = 62;
			consGridBagConstraints5.fill = java.awt.GridBagConstraints.HORIZONTAL;
			consGridBagConstraints5.weightx = 1.0;
			consGridBagConstraints5.gridy = 2;
			consGridBagConstraints5.gridx = 2;
			consGridBagConstraints9.insets = new java.awt.Insets(32,5,8,8);
			consGridBagConstraints9.ipadx = 68;
			consGridBagConstraints9.fill = java.awt.GridBagConstraints.HORIZONTAL;
			consGridBagConstraints9.weightx = 1.0;
			consGridBagConstraints9.gridy = 0;
			consGridBagConstraints9.gridx = 4;
			jContentPane.setLayout(new java.awt.GridBagLayout());
			jContentPane.add(getLblDepart(), consGridBagConstraints1);
			jContentPane.add(getLblDest(), consGridBagConstraints2);
			jContentPane.add(getBtnSearch(), consGridBagConstraints3);
			jContentPane.add(getJScrollPane(), consGridBagConstraints4);
			jContentPane.add(getTxtNumTixx(), consGridBagConstraints5);
			jContentPane.add(getLblNumTixx(), consGridBagConstraints6);
			jContentPane.add(getBtnPurchase(), consGridBagConstraints7);
			jContentPane.add(getComboDepart(), consGridBagConstraints8);
			jContentPane.add(getComboDest(), consGridBagConstraints9);
		}
		return jContentPane;
	}

	private javax.swing.JLabel getLblDepart() {
		if(lblDepart == null) {
			lblDepart = new javax.swing.JLabel();
			lblDepart.setText("Departure:");
			lblDepart.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
		}
		return lblDepart;
	}

	private javax.swing.JLabel getLblDest() {
		if(lblDest == null) {
			lblDest = new javax.swing.JLabel();
			lblDest.setText("Destination:");
			lblDest.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
		}
		return lblDest;
	}

	private javax.swing.JButton getBtnSearch() {
		if(btnSearch == null) {
			btnSearch = new javax.swing.JButton();
			btnSearch.setText("Search");
			btnSearch.setMnemonic(java.awt.event.KeyEvent.VK_S);
			btnSearch.setFont(new java.awt.Font("Dialog", java.awt.Font.BOLD, 12));
			btnSearch.addActionListener(this);
		}
		return btnSearch;
	}

	private javax.swing.JTable getTblFlights() {
		if(tblFlights == null) {
			tblFlights = new javax.swing.JTable();
			tblFlights.getSelectionModel().addListSelectionListener(this);
			tblFlights.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		}
		return tblFlights;
	}

	private javax.swing.JScrollPane getJScrollPane() {
		if(jScrollPane == null) {
			jScrollPane = new javax.swing.JScrollPane();
			jScrollPane.setViewportView(getTblFlights());
		}
		return jScrollPane;
	}

	private javax.swing.JFormattedTextField getTxtNumTixx() {
		if(txtNumTixx == null) {
			txtNumTixx = new javax.swing.JFormattedTextField(new DecimalFormat("#0"));
		}
		return txtNumTixx;
	}

	private javax.swing.JLabel getLblNumTixx() {
		if(lblNumTixx == null) {
			lblNumTixx = new javax.swing.JLabel();
			lblNumTixx.setText("Number of Tickets:");
			lblNumTixx.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
		}
		return lblNumTixx;
	}

	private JCoolButton getBtnPurchase() {
		if(btnPurchase == null) {
			btnPurchase = new JCoolButton();
			btnPurchase.setText("Purchase");
			btnPurchase.addActionListener(this);
		}
		return btnPurchase;
	}

	private javax.swing.JComboBox getComboDepart() {
		if(comboDepart == null) {
			comboDepart = new javax.swing.JComboBox();
		}
		return comboDepart;
	}

	private javax.swing.JComboBox getComboDest() {
		if(comboDest == null) {
			comboDest = new javax.swing.JComboBox();
		}
		return comboDest;
	}


}  //  @jve:visual-info  decl-index=0 visual-constraint="10,10"
